/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.utilities.download;

import io.sigpipe.jbsdiff.InvalidHeaderException;
import io.sigpipe.jbsdiff.ui.FileUI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.montoyo.mcef.MCEF;
import net.montoyo.mcef.client.init.CefInitMenu;
import net.montoyo.mcef.utilities.IProgressListener;
import net.montoyo.mcef.utilities.Resource;
import net.montoyo.mcef.utilities.Util;
import net.montoyo.mcef.utilities.download.ModernDownload;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.io.FileUtils;

public class MCEFDownloader {
    private Properties versions;
    private final IProgressListener listener;
    String osProp = System.getProperty("os.name");

    public MCEFDownloader(IProgressListener listener) {
        this.listener = listener;
    }

    private Map<String, String> fetchFileManifest(String url) throws IOException {
        FileOutputStream outputStream = null;
        if (MCEF.writeMirrorData) {
            String path = url.substring("https://cinemamod-libraries.ewr1.vultrobjects.com/".length());
            File dst = new File("data/" + path);
            if (!dst.exists()) {
                dst.getParentFile().mkdirs();
            }
            outputStream = new FileOutputStream(dst);
        }
        HashMap<String, String> manifest = new HashMap<String, String>();
        try (InputStream inputStream = new URL(url).openStream();
             Scanner scanner = new Scanner(inputStream);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (outputStream != null) {
                    outputStream.write((line + "\n").getBytes(StandardCharsets.UTF_8));
                }
                String sha1hash = line.split(" ")[0];
                String filePath = line.split(" ")[2].substring(1);
                manifest.put(sha1hash, filePath);
            }
        }
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
        return manifest;
    }

    private void fetchVersions() throws IOException {
        FileOutputStream outputStream;
        block19: {
            this.versions = new Properties();
            outputStream = null;
            if (MCEF.writeMirrorData) {
                File dst = new File("data/versions.txt");
                if (!dst.exists()) {
                    dst.getParentFile().mkdirs();
                }
                outputStream = new FileOutputStream(dst);
            }
            URL versionsURL = new URL("https://cinemamod-libraries.ewr1.vultrobjects.com/versions.txt");
            try (InputStream inputStream = versionsURL.openStream();){
                Scanner scanner = new Scanner(inputStream);
                block12: while (true) {
                    while (scanner.hasNextLine()) {
                        String line = scanner.nextLine();
                        if (outputStream != null) {
                            outputStream.write((line + "\n").getBytes(StandardCharsets.UTF_8));
                        }
                        try {
                            String library = line.split(" ")[0];
                            String version = line.split(" ")[1];
                            this.versions.put(library, version);
                            continue block12;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        }
                    }
                    break block19;
                    {
                        continue block12;
                        break;
                    }
                    break;
                }
                finally {
                    scanner.close();
                }
            }
        }
        if (outputStream != null) {
            outputStream.flush();
            outputStream.close();
        }
    }

    private boolean ensureLibFile(String sha1hash, String relPath) {
        Path librariesPath = Paths.get(System.getProperty("cinemamod.libraries.path"), new String[0]);
        File libFile = new File(librariesPath + relPath);
        boolean result = false;
        if (libFile.exists()) {
            try {
                String onDiskHash = Util.sha1Hash(libFile);
                if (sha1hash.equals(onDiskHash)) {
                    result = true;
                } else {
                    System.out.println(libFile + " hash mismatch, will update");
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void downloadLibFile(String remotePath, String relPath) throws IOException {
        Path librariesPath = Paths.get(System.getProperty("cinemamod.libraries.path"), new String[0]);
        this.listener.onTaskChanged("3:Downloading " + remotePath);
        File localFile = new File(librariesPath + relPath);
        FileUtils.copyURLToFile((URL)new URL(remotePath), (File)localFile);
        if (MCEF.writeMirrorData) {
            FileUtils.copyFile((File)localFile, (File)new File("data/" + remotePath.substring("https://cinemamod-libraries.ewr1.vultrobjects.com/".length())));
        }
        if (this.osProp.toLowerCase(Locale.ROOT).contains("linux") && (localFile.toString().contains("chrome-sandbox") || localFile.toString().contains("jcef_helper"))) {
            Util.makeExecNix(localFile);
        }
    }

    private void patchLibFile(String relPath) throws CompressorException, IOException, InvalidHeaderException {
        Path librariesPath = Paths.get(System.getProperty("cinemamod.libraries.path"), new String[0]);
        this.listener.onTaskChanged("3:Patching " + relPath);
        File libFile = new File(librariesPath + relPath);
        File patchFile = new File(libFile + ".diff");
        FileUI.patch(libFile, libFile, patchFile);
    }

    private void ensureJcef(String cefBranch, String platform) throws IOException {
        Map<String, String> patchesManifest;
        Map<String, String> jcefPatchedManifest;
        String jcefManifestUrlString = Resource.getJcefUrl(cefBranch, platform) + "/manifest.txt";
        String jcefPatchedManifestUrlString = Resource.getJcefPatchesUrl(cefBranch, platform) + "/patched-manifest.txt";
        String jcefPatchesManifestUrlString = Resource.getJcefPatchesUrl(cefBranch, platform) + "/manifest.txt";
        if (!MCEF.skipVersionCheck) {
            jcefManifest = this.fetchFileManifest(jcefManifestUrlString);
            jcefPatchedManifest = this.fetchFileManifest(jcefPatchedManifestUrlString);
            patchesManifest = this.fetchFileManifest(jcefPatchesManifestUrlString);
        } else {
            jcefManifest = new HashMap<String, String>();
            jcefPatchedManifest = new HashMap<String, String>();
            patchesManifest = new HashMap<String, String>();
        }
        int fileCount = 0;
        for (Map.Entry<String, String> entry : jcefPatchedManifest.entrySet()) {
            double value = (double)(++fileCount) / (double)jcefPatchedManifest.size();
            this.listener.onProgressed(value);
            String sha1hash = entry.getKey();
            String filePath = entry.getValue();
            this.listener.onTaskChanged("2:Found " + filePath.substring(1));
            if (this.ensureLibFile(sha1hash, filePath)) continue;
            String remotePath = Resource.getJcefUrl(cefBranch, platform) + filePath;
            this.downloadLibFile(remotePath, filePath);
            for (String patchFileName : patchesManifest.values()) {
                if (!patchFileName.startsWith(filePath)) continue;
                String patchRemotePath = Resource.getJcefPatchesUrl(cefBranch, platform) + patchFileName;
                this.downloadLibFile(patchRemotePath, patchFileName);
                try {
                    this.patchLibFile(filePath);
                }
                catch (InvalidHeaderException | CompressorException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void run() {
        if (MCEF.FAVOR_GIT && ModernDownload.download(this.listener)) {
            MCEF.downloadedFromGit = true;
            return;
        }
        this.listener.onTaskChanged("1:Fetching mod version info...");
        try {
            if (!MCEF.skipVersionCheck) {
                this.fetchVersions();
            } else {
                this.versions = new Properties();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("MCEF library versions " + this.versions.toString());
        this.listener.onTaskChanged("2:Current MCEF branch: " + this.versions.getProperty("jcef"));
        String os = this.osProp.toLowerCase(Locale.ROOT);
        String platform = os.contains("win") ? "win64" : (os.contains("mac") ? "mac64" : (os.contains("linux") ? "linux64" : "unknown"));
        this.listener.onTaskChanged("3:Verifying library files...");
        try {
            this.ensureJcef(this.versions.getProperty("jcef"), platform);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (System.getProperty("cinemamod.libraries.path") == null) {
            System.out.println("Not running inside Minecraft");
            return;
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        MCEFDownloader downloader = new MCEFDownloader(CefInitMenu.listener);
        downloader.run();
        downloader.listener.onProgressEnd();
    }
}

